  import java.io.File;
  import java.io.IOException;
  import javafx.application.Application;
  import javafx.event.ActionEvent;
  import javafx.scene.Scene;
  import javafx.scene.layout.Pane;
  import javafx.stage.FileChooser;
  import javafx.stage.Stage;

  public class FileChoosers extends Application 
  {
     @Override
     public void start(Stage primaryStage) throws IOException 
     {
        Pane root = new Pane();

        FileChooser fileChooser = new FileChooser();
        File file;
        
        // Open a file
        file = fileChooser.showOpenDialog(primaryStage);
        if (file != null) // Open was clicked
        {
            System.out.println("The path to read the file from is:\n" + 
                               file.getPath());
        }
        
        // Save a file
        file = fileChooser.showSaveDialog(primaryStage);
        if (file != null) // Save was clicked 
        {
            System.out.println("The path to write the file to is:\n" + 
                               file.getPath());
        }
        
        Scene scene = new Scene(root, 400, 250);
        primaryStage.setTitle("File Chooser Dialogs");
        primaryStage.setScene(scene);
        primaryStage.show();
     }  

     public static void main(String[] args) 
     {
        launch(args);
     }
  }
   
